<?php
/**
 * ----------------------------------------------------
 * Process Simpanan
 * ----------------------------------------------------
 */

require_once '../config/config.php';
require_once '../config/database.php';
require_once '../config/auth.php';

// Validasi role
if (!in_array($user_role, ['admin','petugas'])) {
    die('Akses ditolak');
}

$anggota_id = $_POST['anggota_id'] ?? null;
$jenis      = $_POST['jenis'] ?? null;
$jumlah     = $_POST['jumlah'] ?? 0;
$tanggal    = $_POST['tanggal'] ?? date('Y-m-d');
$keterangan = $_POST['keterangan'] ?? '';

// Validasi dasar
if (!$anggota_id || !$jenis || $jumlah <= 0) {
    die('Data tidak valid');
}

// --------------------------------------------------
// INSERT SIMPANAN
// --------------------------------------------------
$stmt = $db->prepare("
    INSERT INTO simpanan 
    (anggota_id, jenis, jumlah, tanggal, keterangan)
    VALUES (?, ?, ?, ?, ?)
");
$stmt->execute([
    $anggota_id,
    $jenis,
    $jumlah,
    $tanggal,
    $keterangan
]);

// --------------------------------------------------
// INSERT KE KAS (MASUK)
// --------------------------------------------------
$stmtKas = $db->prepare("
    INSERT INTO kas (tanggal, masuk, keluar, keterangan)
    VALUES (?, ?, 0, ?)
");

$ketKas = "Simpanan " . ucfirst($jenis) . " Anggota ID: " . $anggota_id;
$stmtKas->execute([$tanggal, $jumlah, $ketKas]);

// --------------------------------------------------
// REDIRECT SESUAI JENIS
// --------------------------------------------------
header("Location: ../modules/simpanan/{$jenis}.php");
exit;
